/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.outconn;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rcs.outconn.InternetVpnBean;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigData;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConnectivityConstants;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConnectivityTasklet;
import com.ibm.hwmca.fw.rcs.outconn.TestInternetVpnBean;
import com.ibm.hwmca.fw.rcs.outconn.TestInternetVpnThread;
import com.ibm.hwmca.fw.rcs.path.PathPlatform;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import java.util.HashMap;

public class InternetVpnTasklet
extends PanelTasklet
implements OutboundConnectivityConstants {
    private static final String TRACE_MASKT = "XRCSIVTT";
    private static final String TRACE_MASKF = "XRCSIVTF";
    private static final String TRACE_MASKD = "XRCSIVTD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RCS-IVpnTskl");
    private InternetVpnBean internetVpnBean;
    private TestInternetVpnThread testInternetVpnThread;
    private PathPlatform pathPlatform = null;

    public InternetVpnTasklet() {
        Trace.trace(TRACE_MASKT, "<> InternetVpnTasklet()");
    }

    public void init() throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> init()");
        Trace.trace(TRACE_MASKT, "<- init()");
    }

    public void destroy() {
        this.deactiviateTestThread();
        super.destroy();
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> service(" + request + ", " + response + ")");
        try {
            if (request.isInitialRequest()) {
                this.pathPlatform = (PathPlatform)request.getData("PathPlatform");
                this.internetVpnBean = new InternetVpnBean();
                this.internetVpnBean.setBeanName("InternetVpnBean");
                OutboundConnectivityTasklet outConnTasklet = (OutboundConnectivityTasklet)this.getParent();
                OutboundConfigData outConfigData = outConnTasklet.getOutboundConfigData();
                this.internetVpnBean.setCallHomeServer(outConfigData.isCallHomeServer());
                this.internetVpnBean.setAllowVpn(outConfigData.isAllowInternet());
                response.replace("com.ibm.hwmca.fw.rcs.outconn.res.OutboundConnRes", "InternetVpnPanel", this.internetVpnBean);
            } else if (request.isDisposed() || request.isCanceled()) {
                response.terminate();
            } else {
                String source = (String)request.getData("Source");
                if (source == null) {
                    source = "";
                }
                Trace.trace(TRACE_MASKF, "source=" + source);
                if (source.equals("")) {
                    Trace.trace(TRACE_MASKF, "Unspecified source");
                    response.noAction();
                } else if (source.equals("InternetVpnPanel")) {
                    this.serviceInternetVpnPanel(request, response);
                } else if (source.equals("TestInternetVpnPanel")) {
                    this.serviceTestInternetVpnPanel(request, response);
                } else {
                    Trace.trace(TRACE_MASKF, "Unknown source");
                    response.noAction();
                }
            }
        }
        catch (TaskletException te) {
            throw te;
        }
        catch (Exception e) {
            throw new TaskletException(e);
        }
        Trace.trace(TRACE_MASKT, "<- service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> logException(" + throwable + ")");
        new FrameworkLog(classLogInfo, 1940, throwable).log();
        Trace.trace(TRACE_MASKT, "<- logException()");
    }

    private void serviceInternetVpnPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> serviceInternetVpnPanel()");
        String command = (String)request.getData("Command");
        if (command == null) {
            command = "";
        }
        Trace.trace(TRACE_MASKF, "command=" + command);
        if (command.equals("")) {
            Trace.trace(TRACE_MASKF, "Unspecified command");
            response.noAction();
        } else if (command.equals("OpenTestPanel")) {
            TestInternetVpnBean testInternetVpnBean = new TestInternetVpnBean();
            testInternetVpnBean.setBeanName("TestInternetVpnBean");
            response.openModalChild("com.ibm.hwmca.fw.rcs.outconn.res.OutboundConnRes", "TestInternetVpnPanel", testInternetVpnBean);
        } else if (command.equals("Commit")) {
            InternetVpnBean bean = (InternetVpnBean)request.getData("Bean");
            if (bean != null) {
                OutboundConnectivityTasklet outConnTasklet = (OutboundConnectivityTasklet)this.getParent();
                OutboundConfigData outConfigData = outConnTasklet.getOutboundConfigData();
                outConfigData.setAllowInternet(bean.isAllowVpn());
            }
            response.noAction();
        } else {
            Trace.trace(TRACE_MASKF, "Unknown command");
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- serviceInternetVpnPanel()");
    }

    private void serviceTestInternetVpnPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> serviceTestInternetVpnPanel()");
        String command = (String)request.getData("Command");
        if (command == null) {
            command = "";
        }
        Trace.trace(TRACE_MASKF, "command=" + command);
        if (command.equals("")) {
            Trace.trace(TRACE_MASKF, "Unspecified command");
            response.noAction();
        } else if (command.equals("Start")) {
            this.testInternetVpnThread = new TestInternetVpnThread(this, this.pathPlatform);
            this.testInternetVpnThread.start();
            response.noAction();
        } else if (command.equals("Stop")) {
            this.deactiviateTestThread();
            response.noAction();
        } else if (command.equals("UpdateStatus")) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("Command", command);
            data.put("StatusInfo", request.getData("StatusInfo"));
            response.update("TestInternetVpnBean", data);
        } else if (command.equals("TestComplete")) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("Command", command);
            response.update("TestInternetVpnBean", data);
        } else if (command.equals("Cancel")) {
            this.deactiviateTestThread();
            response.dispose();
        } else {
            Trace.trace(TRACE_MASKF, "Unknown command");
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- serviceTestInternetVpnPanel()");
    }

    private void deactiviateTestThread() {
        Trace.trace(TRACE_MASKT, "-> deactivateTestThread()");
        if (this.testInternetVpnThread != null) {
            this.testInternetVpnThread.cancel();
        } else {
            Trace.trace(TRACE_MASKF, "No test thread active");
        }
        Trace.trace(TRACE_MASKT, "<- deactivateTestThread()");
    }
}

